﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Menu.MenuSample5
{
    public partial class FormMain : Form
    {
        public const int MF_ByPosition = 0x400;
        public const int MF_ByCommand = 0x0;

        [DllImport("user32.dll")]
        public static extern IntPtr GetMenuItemID(IntPtr hMenu, int nPosition);

        [DllImport("user32.dll")]
        public static extern bool SetMenuItemBitmaps(IntPtr hMenu, int nPosition, int wFlags, IntPtr hBitmapUnchecked, IntPtr hBitmapChecked);

        [DllImport("user32.dll")]
        public static extern IntPtr GetSystemMenu(IntPtr hwnd, bool bRevert);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonChange_Click(object sender, EventArgs e)
        {
            IntPtr hSystemMenu = GetSystemMenu(this.Handle, false);
            if (hSystemMenu == IntPtr.Zero) return;

            Bitmap bmpSizeMenuItem = new Bitmap(PictureChecked.Image); //or bitmapFilePath
            Color backColor = bmpSizeMenuItem.GetPixel(1, 1);
            bmpSizeMenuItem.MakeTransparent(backColor);
            IntPtr intPtrBmpSizeMenuItem = bmpSizeMenuItem.GetHbitmap();

            // Change By Position ==> pos Size=2
            SetMenuItemBitmaps(hSystemMenu, 2, MF_ByPosition, intPtrBmpSizeMenuItem, intPtrBmpSizeMenuItem);

            Bitmap bmpMoveMenuItem = new Bitmap(PictureUnChecked.Image); //or bitmapFilePath
            backColor = bmpMoveMenuItem.GetPixel(1, 1);
            bmpMoveMenuItem.MakeTransparent(backColor);
            IntPtr intPtrBmpMoveMenuItem = bmpMoveMenuItem.GetHbitmap();

            // move item position is 1
            IntPtr moveItemID = GetMenuItemID(hSystemMenu, 1);
            // Change By Command
            SetMenuItemBitmaps(hSystemMenu, moveItemID.ToInt32(), MF_ByCommand, intPtrBmpMoveMenuItem, intPtrBmpMoveMenuItem);
        }
    }
}